/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.generators;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import technology.rocketjump.undermount.mapgen.generators.SimplexNoise;
import technology.rocketjump.undermount.mapgen.model.RockGroup;
import technology.rocketjump.undermount.mapgen.model.RoofType;
import technology.rocketjump.undermount.mapgen.model.input.GameMapGenerationParams;
import technology.rocketjump.undermount.mapgen.model.input.RockType;
import technology.rocketjump.undermount.mapgen.model.output.GameMap;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;

public class RockTypeGenerator {
    public void assignRockGroups(GameMap gameMap, Random random) {
        int largestFeature = 200;
        double persistence = 0.4;
        SimplexNoise simplexNoise = new SimplexNoise(largestFeature, persistence, random);
        for (int x = 0; x < gameMap.getWidth(); ++x) {
            for (int y = 0; y < gameMap.getHeight(); ++y) {
                GameMapTile tile = gameMap.get(x, y);
                if (tile.getRoofType() != RoofType.Underground) continue;
                float noise = (float)simplexNoise.getNoise(x, y);
                if ((noise = (noise + 1.0f) / 2.0f) > 0.6f) {
                    tile.setRockGroup(RockGroup.Metamorphic);
                } else {
                    float heightThreshold = 0.8f - noise;
                    if (tile.getHeightMapValue() > heightThreshold) {
                        tile.setRockGroup(RockGroup.Igneous);
                    } else {
                        tile.setRockGroup(RockGroup.Sedimentary);
                    }
                }
                tile.setDebugValue(noise);
            }
        }
    }

    public void assignRockTypes(GameMap gameMap, GameMapGenerationParams generationParams, Random random) {
        for (int x = 0; x < gameMap.getWidth(); ++x) {
            for (int y = 0; y < gameMap.getHeight(); ++y) {
                GameMapTile tile = gameMap.get(x, y);
                if (tile.getRockGroup().equals((Object)RockGroup.None) || tile.getRockType() != null) continue;
                RockGroup rockGroup = tile.getRockGroup();
                RockType rockTypeToApply = this.pickRockType(generationParams.getRockTypes(rockGroup), random);
                LinkedList<GameMapTile> frontier = new LinkedList<GameMapTile>();
                HashSet<GameMapTile> explored = new HashSet<GameMapTile>();
                frontier.add(tile);
                while (!frontier.isEmpty()) {
                    GameMapTile currentTile = (GameMapTile)frontier.removeFirst();
                    if (explored.contains(currentTile)) continue;
                    if (rockGroup.equals((Object)currentTile.getRockGroup()) && currentTile.getRockType() == null) {
                        currentTile.setRockType(rockTypeToApply);
                        for (GameMapTile neighbour : gameMap.getOrthogonalNeighbours(currentTile.getPosition())) {
                            if (explored.contains(neighbour)) continue;
                            frontier.add(neighbour);
                        }
                    }
                    explored.add(currentTile);
                }
            }
        }
    }

    private RockType pickRockType(List<RockType> rockTypes, Random random) {
        float totalWeightings = 0.0f;
        for (RockType rockType : rockTypes) {
            totalWeightings += rockType.getWeighting();
        }
        float weightingPicker = random.nextFloat() * totalWeightings;
        for (RockType rockType : rockTypes) {
            if (!((weightingPicker -= rockType.getWeighting()) <= 0.0f)) continue;
            return rockType;
        }
        System.err.println("Logic error picking rock type in " + this.getClass().getName());
        return rockTypes.get(0);
    }
}

